version	equ	2

	include	defs.asm	;SEE ENCLOSED COPYRIGHT MESSAGE

code	segment	byte public
	assume	cs:code, ds:code

	public	int_no
int_no	db	?,?

	public	driver_class, driver_type, driver_name
driver_class	db	0		;from the packet spec
driver_type	db	0		;from the packet spec
driver_name	db	'generic',0	;name of the driver.

	public	send_pkt
send_pkt:
;enter with ds:si -> packet, cx = packet length.
;exit with nc if ok, or else cy if error, dh set to error number.
	ret


	public	get_address
get_address:
;get the address of the interface.
;enter with es:di -> place to get the address, cx = size of address buffer.
;exit with nc, cx = actual size of address, or cy if buffer not big enough.
	ret


	public	reset_interface
reset_interface:
;reset the interface.
	ret


;called when we want to determine what to do with a received packet.
;enter with cx = packet length, es:di -> packet type.
	extrn	recv_find: near

;called after we have copied the packet into the buffer.
;enter with ds:si ->the packet, cx = length of the packet.
	extrn	recv_copy: near

	extrn	count_in_err: near
	extrn	count_out_err: near

	public	recv
recv:
;called from the recv isr.  All registers have been saved, and ds=cs.
;Upon exit, the interrupt will be acknowledged.
	assume	ds:code
	ret


;any code after this will not be kept after initialization.
end_resident	label	byte


	public	usage_msg
usage_msg	db	"usage: generic <packet_int_no>",CR,LF,'$'

	public	copyright_msg
copyright_msg	db	"Packet driver for a generic device, version ",'0'+version,CR,LF,'$'
		db	"Portions Copyright 19xx, J. Random Hacker",CR,LF,'$'

	extrn	set_recv_isr: near

;enter with si -> argument string, di -> word to store.
;if there is no number, don't change the number.
	extrn	get_number: near

	public	parse_args
parse_args:
	ret


	public	etopen
etopen:
;if all is okay,
	mov	dx,offset end_resident
	clc
	ret
;if we got an error,
	stc
	ret

code	ends

	end
